<?php

namespace WeDevs\DokanPro\Modules\Elementor\Tags;

use WeDevs\DokanPro\Modules\Elementor\Abstracts\TagBase;

class StoreSupportButton extends TagBase {

    /**
     * Class constructor
     *
     * @since 2.9.11
     *
     * @param array $data
     */
    public function __construct( $data = [] ) {
        parent::__construct( $data );
    }

    /**
     * Tag name
     *
     * @since 2.9.11
     *
     * @return string
     */
    public function get_name() {
        return 'dokan-store-support-button-tag';
    }

    /**
     * Tag title
     *
     * @since 2.9.11
     *
     * @return string
     */
    public function get_title() {
        return __( 'Store Support Button', 'dokan' );
    }

    /**
     * Render tag
     *
     * @since 2.9.11
     *
     * @return void
     */
    public function render() {
        if ( ! dokan_pro()->module->is_active( 'store_support' ) ) {
            echo __( 'Dokan Store Support module is not active', 'dokan' );
            return;
        }

        $text = __( 'Get Support', 'dokan' );

        if ( dokan_is_store_page() ) {
            $id = dokan_elementor()->get_store_data( 'id' );

            if ( $id ) {
                $store_support  = dokan_pro()->module->store_support;
                $support_button = $store_support->get_support_button( $id );

                if ( $support_button['show'] ) {
                    $text = $support_button['text'];
                }
            }
        }

        echo $text;
    }
}
