/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./modules/geolocation/assets/src/js/locations-map-google-maps.js":
/*!************************************************************************!*\
  !*** ./modules/geolocation/assets/src/js/locations-map-google-maps.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _markerclusterer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./markerclusterer */ \"./modules/geolocation/assets/src/js/markerclusterer.js\");\n\n\n(function ($) {\n  DokanGeo.LocationsMaps = {\n    map: null,\n    markers: [],\n    marker_clusterer: null,\n    info_window: null,\n    init: function init() {\n      var self = this;\n      var map_area = $('#dokan-geolocation-locations-map');\n      self.map = new google.maps.Map(map_area.get(0), {\n        zoom: parseInt(DokanGeo.map_zoom, 10),\n        mapTypeId: google.maps.MapTypeId.ROADMAP\n      });\n      self.info_window = new google.maps.InfoWindow();\n      self.setMarkers();\n      self.map.addListener('clusterclick', function (cluster) {\n        var bounds = cluster.getBounds(),\n            markers = cluster.getMarkers(); // At first I was using if ( bounds.b.f === bounds.b.b ) condition,\n        // then saw that bounds doesn't contain b any more. So, I'm trying to\n        // use dynamic key properties here.\n\n        var bounds_props = Object.keys(bounds),\n            bound_1st_prop_props = Object.keys(bounds[bounds_props[0]]),\n            f = bounds[bounds_props[0]][bound_1st_prop_props[0]],\n            b = bounds[bounds_props[0]][bound_1st_prop_props[1]];\n\n        if (f === b) {\n          var html = '<div class=\"white-popup dokan-geo-map-info-windows-in-popup\">';\n          markers.forEach(function (marker) {\n            html += self.getInfoWindowContent(marker.info);\n          });\n          html += '</div>';\n          $.magnificPopup.open({\n            items: {\n              type: 'inline',\n              src: html\n            }\n          });\n        }\n      });\n    },\n    setMarkers: function setMarkers() {\n      var items = $('[name=\"dokan_geolocation[]\"]');\n\n      if (!items.length) {\n        var search = window.location.search,\n            latitude = DokanGeo.default_geolocation.latitude,\n            longitude = DokanGeo.default_geolocation.longitude,\n            queries = search.replace('?', '').split('&'),\n            i = 0;\n\n        if (queries.length) {\n          var query = '',\n              param = '',\n              value = '';\n\n          for (i = 0; i < queries.length; i++) {\n            query = queries[i].split('=');\n            param = query[0].toLowerCase();\n            value = query[1];\n\n            if ('latitude' === param) {\n              latitude = value;\n            } else if ('longitude' === param) {\n              longitude = value;\n            }\n          }\n        }\n\n        this.map.setCenter(new google.maps.LatLng(latitude, longitude));\n        return;\n      }\n\n      var self = this,\n          bound = new google.maps.LatLngBounds();\n      var marker_icon = {\n        url: DokanGeo.marker.image,\n        scaledSize: new google.maps.Size(32, 32)\n      };\n\n      if (self.marker_clusterer) {\n        self.marker_clusterer.clearMarkers();\n      }\n\n      self.markers = [];\n      items.each(function () {\n        var id = $(this).val(),\n            latitude = $(this).data('latitude'),\n            longitude = $(this).data('longitude'),\n            info = $(this).data('info');\n        var curpoint = new google.maps.LatLng(latitude, longitude);\n        bound.extend(curpoint);\n        var marker_options = {\n          position: curpoint,\n          map: self.map,\n          info: info\n        };\n\n        if (DokanGeo.marker.image) {\n          marker_options.icon = marker_icon;\n        }\n\n        var marker = new google.maps.Marker(marker_options);\n        marker.addListener('click', function () {\n          if (!info) {\n            return;\n          }\n\n          var info_window_content = self.getInfoWindowContent(info);\n          self.info_window.setContent(info_window_content);\n          self.info_window.open(self.map, marker);\n          self.map.panTo(curpoint);\n        });\n        self.markers.push(marker);\n      });\n      self.map.setCenter(bound.getCenter());\n\n      if (parseInt(DokanGeo.is_auto_zoom) === 1) {\n        self.map.fitBounds(bound);\n        setTimeout(function () {\n          if (self.map.getZoom() > parseInt(DokanGeo.map_zoom)) {\n            self.map.setZoom(parseInt(DokanGeo.map_zoom));\n          }\n        }, 1500);\n      }\n\n      var i = 0,\n          styles = [];\n\n      for (i = 0; i < 5; i++) {\n        styles.push({\n          url: DokanGeo.marker.clusterer,\n          height: 40,\n          width: 40,\n          textColor: '#fddace',\n          textSize: 13,\n          backgroundSize: '40px'\n        });\n      }\n\n      self.marker_clusterer = new _markerclusterer__WEBPACK_IMPORTED_MODULE_0__[\"default\"](self.map, self.markers, {\n        gridSize: 40,\n        styles: styles\n      });\n    },\n    getInfoWindowContent: function getInfoWindowContent(info) {\n      var content = DokanGeo.info_window_template,\n          infoProp;\n\n      for (infoProp in info) {\n        content = content.replace('{' + infoProp + '}', info[infoProp]);\n      }\n\n      return content;\n    }\n  };\n\n  if ($('#dokan-geolocation-locations-map').length) {\n    DokanGeo.LocationsMaps.init();\n  }\n})(jQuery);\n\n//# sourceURL=webpack://dokan-pro/./modules/geolocation/assets/src/js/locations-map-google-maps.js?");

/***/ }),

/***/ "./modules/geolocation/assets/src/js/markerclusterer.js":
/*!**************************************************************!*\
  !*** ./modules/geolocation/assets/src/js/markerclusterer.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (__WEBPACK_DEFAULT_EXPORT__)\n/* harmony export */ });\n/* harmony import */ var _babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @babel/runtime/helpers/typeof */ \"./node_modules/@babel/runtime/helpers/esm/typeof.js\");\n\n\n// ==ClosureCompiler==\n// @compilation_level ADVANCED_OPTIMIZATIONS\n// @externs_url http://closure-compiler.googlecode.com/svn/trunk/contrib/externs/maps/google_maps_api_v3_3.js\n// ==/ClosureCompiler==\n\n/**\n * @name MarkerClusterer for Google Maps v3\n * @version version 1.0.2\n * @author Luke Mahe\n * @fileoverview\n * The library creates and manages per-zoom-level clusters for large amounts of\n * markers.\n */\n\n/**\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *     http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * A Marker Clusterer that clusters markers.\n *\n * @param {google.maps.Map} map The Google map to attach to.\n * @param {Array.<google.maps.Marker>=} opt_markers Optional markers to add to\n *   the cluster.\n * @param {Object=} opt_options support the following options:\n *     'gridSize': (number) The grid size of a cluster in pixels.\n *     'maxZoom': (number) The maximum zoom level that a marker can be part of a\n *                cluster.\n *     'zoomOnClick': (boolean) Whether the default behaviour of clicking on a\n *                    cluster is to zoom into it.\n *     'imagePath': (string) The base URL where the images representing\n *                  clusters will be found. The full URL will be:\n *                  {imagePath}[1-5].{imageExtension}\n *                  Default: '../images/m'.\n *     'imageExtension': (string) The suffix for images URL representing\n *                       clusters will be found. See _imagePath_ for details.\n *                       Default: 'png'.\n *     'averageCenter': (boolean) Whether the center of each cluster should be\n *                      the average of all markers in the cluster.\n *     'minimumClusterSize': (number) The minimum number of markers to be in a\n *                           cluster before the markers are hidden and a count\n *                           is shown.\n *     'styles': (object) An object that has style properties:\n *       'url': (string) The image url.\n *       'height': (number) The image height.\n *       'width': (number) The image width.\n *       'anchor': (Array) The anchor position of the label text.\n *       'textColor': (string) The text color.\n *       'textSize': (number) The text size.\n *       'backgroundPosition': (string) The position of the backgound x, y.\n *       'backgroundSize': (string) The background size\n * @constructor\n * @extends google.maps.OverlayView\n */\nfunction MarkerClusterer(map, opt_markers, opt_options) {\n  // MarkerClusterer implements google.maps.OverlayView interface. We use the\n  // extend function to extend MarkerClusterer with google.maps.OverlayView\n  // because it might not always be available when the code is defined so we\n  // look for it at the last possible moment. If it doesn't exist now then\n  // there is no point going ahead :)\n  this.extend(MarkerClusterer, google.maps.OverlayView);\n  this.map_ = map;\n  /**\n   * @type {Array.<google.maps.Marker>}\n   * @private\n   */\n\n  this.markers_ = [];\n  /**\n   *  @type {Array.<Cluster>}\n   */\n\n  this.clusters_ = [];\n  this.sizes = [53, 56, 66, 78, 90];\n  /**\n   * @private\n   */\n\n  this.styles_ = [];\n  /**\n   * @type {boolean}\n   * @private\n   */\n\n  this.ready_ = false;\n  var options = opt_options || {};\n  /**\n   * @type {number}\n   * @private\n   */\n\n  this.gridSize_ = options['gridSize'] || 60;\n  /**\n   * @private\n   */\n\n  this.minClusterSize_ = options['minimumClusterSize'] || 2;\n  /**\n   * @type {?number}\n   * @private\n   */\n\n  this.maxZoom_ = options['maxZoom'] || null;\n  this.styles_ = options['styles'] || [];\n  /**\n   * @type {string}\n   * @private\n   */\n\n  this.imagePath_ = options['imagePath'] || this.MARKER_CLUSTER_IMAGE_PATH_;\n  /**\n   * @type {string}\n   * @private\n   */\n\n  this.imageExtension_ = options['imageExtension'] || this.MARKER_CLUSTER_IMAGE_EXTENSION_;\n  /**\n   * @type {boolean}\n   * @private\n   */\n\n  this.zoomOnClick_ = true;\n\n  if (options['zoomOnClick'] != undefined) {\n    this.zoomOnClick_ = options['zoomOnClick'];\n  }\n  /**\n   * @type {boolean}\n   * @private\n   */\n\n\n  this.averageCenter_ = false;\n\n  if (options['averageCenter'] != undefined) {\n    this.averageCenter_ = options['averageCenter'];\n  }\n\n  this.setupStyles_();\n  this.setMap(map);\n  /**\n   * @type {number}\n   * @private\n   */\n\n  this.prevZoom_ = this.map_.getZoom(); // Add the map event listeners\n\n  var that = this;\n  google.maps.event.addListener(this.map_, 'zoom_changed', function () {\n    // Determines map type and prevent illegal zoom levels\n    var zoom = that.map_.getZoom();\n    var minZoom = that.map_.minZoom || 0;\n    var maxZoom = Math.min(that.map_.maxZoom || 100, that.map_.mapTypes[that.map_.getMapTypeId()].maxZoom);\n    zoom = Math.min(Math.max(zoom, minZoom), maxZoom);\n\n    if (that.prevZoom_ != zoom) {\n      that.prevZoom_ = zoom;\n      that.resetViewport();\n    }\n  });\n  google.maps.event.addListener(this.map_, 'idle', function () {\n    that.redraw();\n  }); // Finally, add the markers\n\n  if (opt_markers && (opt_markers.length || Object.keys(opt_markers).length)) {\n    this.addMarkers(opt_markers, false);\n  }\n}\n/**\n * The marker cluster image path.\n *\n * @type {string}\n * @private\n */\n\n\nMarkerClusterer.prototype.MARKER_CLUSTER_IMAGE_PATH_ = '../images/m';\n/**\n * The marker cluster image path.\n *\n * @type {string}\n * @private\n */\n\nMarkerClusterer.prototype.MARKER_CLUSTER_IMAGE_EXTENSION_ = 'png';\n/**\n * Extends a objects prototype by anothers.\n *\n * @param {Object} obj1 The object to be extended.\n * @param {Object} obj2 The object to extend with.\n * @return {Object} The new extended object.\n * @ignore\n */\n\nMarkerClusterer.prototype.extend = function (obj1, obj2) {\n  return function (object) {\n    for (var property in object.prototype) {\n      this.prototype[property] = object.prototype[property];\n    }\n\n    return this;\n  }.apply(obj1, [obj2]);\n};\n/**\n * Implementaion of the interface method.\n * @ignore\n */\n\n\nMarkerClusterer.prototype.onAdd = function () {\n  this.setReady_(true);\n};\n/**\n * Implementaion of the interface method.\n * @ignore\n */\n\n\nMarkerClusterer.prototype.draw = function () {};\n/**\n * Sets up the styles object.\n *\n * @private\n */\n\n\nMarkerClusterer.prototype.setupStyles_ = function () {\n  if (this.styles_.length) {\n    return;\n  }\n\n  for (var i = 0, size; size = this.sizes[i]; i++) {\n    this.styles_.push({\n      url: this.imagePath_ + (i + 1) + '.' + this.imageExtension_,\n      height: size,\n      width: size\n    });\n  }\n};\n/**\n *  Fit the map to the bounds of the markers in the clusterer.\n */\n\n\nMarkerClusterer.prototype.fitMapToMarkers = function () {\n  var markers = this.getMarkers();\n  var bounds = new google.maps.LatLngBounds();\n\n  for (var i = 0, marker; marker = markers[i]; i++) {\n    bounds.extend(marker.getPosition());\n  }\n\n  this.map_.fitBounds(bounds);\n};\n/**\n *  Sets the styles.\n *\n *  @param {Object} styles The style to set.\n */\n\n\nMarkerClusterer.prototype.setStyles = function (styles) {\n  this.styles_ = styles;\n};\n/**\n *  Gets the styles.\n *\n *  @return {Object} The styles object.\n */\n\n\nMarkerClusterer.prototype.getStyles = function () {\n  return this.styles_;\n};\n/**\n * Whether zoom on click is set.\n *\n * @return {boolean} True if zoomOnClick_ is set.\n */\n\n\nMarkerClusterer.prototype.isZoomOnClick = function () {\n  return this.zoomOnClick_;\n};\n/**\n * Whether average center is set.\n *\n * @return {boolean} True if averageCenter_ is set.\n */\n\n\nMarkerClusterer.prototype.isAverageCenter = function () {\n  return this.averageCenter_;\n};\n/**\n *  Returns the array of markers in the clusterer.\n *\n *  @return {Array.<google.maps.Marker>} The markers.\n */\n\n\nMarkerClusterer.prototype.getMarkers = function () {\n  return this.markers_;\n};\n/**\n *  Returns the number of markers in the clusterer\n *\n *  @return {Number} The number of markers.\n */\n\n\nMarkerClusterer.prototype.getTotalMarkers = function () {\n  return this.markers_.length;\n};\n/**\n *  Sets the max zoom for the clusterer.\n *\n *  @param {number} maxZoom The max zoom level.\n */\n\n\nMarkerClusterer.prototype.setMaxZoom = function (maxZoom) {\n  this.maxZoom_ = maxZoom;\n};\n/**\n *  Gets the max zoom for the clusterer.\n *\n *  @return {number} The max zoom level.\n */\n\n\nMarkerClusterer.prototype.getMaxZoom = function () {\n  return this.maxZoom_;\n};\n/**\n *  The function for calculating the cluster icon image.\n *\n *  @param {Array.<google.maps.Marker>} markers The markers in the clusterer.\n *  @param {number} numStyles The number of styles available.\n *  @return {Object} A object properties: 'text' (string) and 'index' (number).\n *  @private\n */\n\n\nMarkerClusterer.prototype.calculator_ = function (markers, numStyles) {\n  var index = 0;\n  var count = markers.length;\n  var dv = count;\n\n  while (dv !== 0) {\n    dv = parseInt(dv / 10, 10);\n    index++;\n  }\n\n  index = Math.min(index, numStyles);\n  return {\n    text: count,\n    index: index\n  };\n};\n/**\n * Set the calculator function.\n *\n * @param {function(Array, number)} calculator The function to set as the\n *     calculator. The function should return a object properties:\n *     'text' (string) and 'index' (number).\n *\n */\n\n\nMarkerClusterer.prototype.setCalculator = function (calculator) {\n  this.calculator_ = calculator;\n};\n/**\n * Get the calculator function.\n *\n * @return {function(Array, number)} the calculator function.\n */\n\n\nMarkerClusterer.prototype.getCalculator = function () {\n  return this.calculator_;\n};\n/**\n * Add an array of markers to the clusterer.\n *\n * @param {Array.<google.maps.Marker>} markers The markers to add.\n * @param {boolean=} opt_nodraw Whether to redraw the clusters.\n */\n\n\nMarkerClusterer.prototype.addMarkers = function (markers, opt_nodraw) {\n  if (markers.length) {\n    for (var i = 0, marker; marker = markers[i]; i++) {\n      this.pushMarkerTo_(marker);\n    }\n  } else if (Object.keys(markers).length) {\n    for (var marker in markers) {\n      this.pushMarkerTo_(markers[marker]);\n    }\n  }\n\n  if (!opt_nodraw) {\n    this.redraw();\n  }\n};\n/**\n * Pushes a marker to the clusterer.\n *\n * @param {google.maps.Marker} marker The marker to add.\n * @private\n */\n\n\nMarkerClusterer.prototype.pushMarkerTo_ = function (marker) {\n  marker.isAdded = false;\n\n  if (marker['draggable']) {\n    // If the marker is draggable add a listener so we update the clusters on\n    // the drag end.\n    var that = this;\n    google.maps.event.addListener(marker, 'dragend', function () {\n      marker.isAdded = false;\n      that.repaint();\n    });\n  }\n\n  this.markers_.push(marker);\n};\n/**\n * Adds a marker to the clusterer and redraws if needed.\n *\n * @param {google.maps.Marker} marker The marker to add.\n * @param {boolean=} opt_nodraw Whether to redraw the clusters.\n */\n\n\nMarkerClusterer.prototype.addMarker = function (marker, opt_nodraw) {\n  this.pushMarkerTo_(marker);\n\n  if (!opt_nodraw) {\n    this.redraw();\n  }\n};\n/**\n * Removes a marker and returns true if removed, false if not\n *\n * @param {google.maps.Marker} marker The marker to remove\n * @return {boolean} Whether the marker was removed or not\n * @private\n */\n\n\nMarkerClusterer.prototype.removeMarker_ = function (marker) {\n  var index = -1;\n\n  if (this.markers_.indexOf) {\n    index = this.markers_.indexOf(marker);\n  } else {\n    for (var i = 0, m; m = this.markers_[i]; i++) {\n      if (m == marker) {\n        index = i;\n        break;\n      }\n    }\n  }\n\n  if (index == -1) {\n    // Marker is not in our list of markers.\n    return false;\n  }\n\n  marker.setMap(null);\n  this.markers_.splice(index, 1);\n  return true;\n};\n/**\n * Remove a marker from the cluster.\n *\n * @param {google.maps.Marker} marker The marker to remove.\n * @param {boolean=} opt_nodraw Optional boolean to force no redraw.\n * @return {boolean} True if the marker was removed.\n */\n\n\nMarkerClusterer.prototype.removeMarker = function (marker, opt_nodraw) {\n  var removed = this.removeMarker_(marker);\n\n  if (!opt_nodraw && removed) {\n    this.resetViewport();\n    this.redraw();\n    return true;\n  } else {\n    return false;\n  }\n};\n/**\n * Removes an array of markers from the cluster.\n *\n * @param {Array.<google.maps.Marker>} markers The markers to remove.\n * @param {boolean=} opt_nodraw Optional boolean to force no redraw.\n */\n\n\nMarkerClusterer.prototype.removeMarkers = function (markers, opt_nodraw) {\n  // create a local copy of markers if required\n  // (removeMarker_ modifies the getMarkers() array in place)\n  var markersCopy = markers === this.getMarkers() ? markers.slice() : markers;\n  var removed = false;\n\n  for (var i = 0, marker; marker = markersCopy[i]; i++) {\n    var r = this.removeMarker_(marker);\n    removed = removed || r;\n  }\n\n  if (!opt_nodraw && removed) {\n    this.resetViewport();\n    this.redraw();\n    return true;\n  }\n};\n/**\n * Sets the clusterer's ready state.\n *\n * @param {boolean} ready The state.\n * @private\n */\n\n\nMarkerClusterer.prototype.setReady_ = function (ready) {\n  if (!this.ready_) {\n    this.ready_ = ready;\n    this.createClusters_();\n  }\n};\n/**\n * Returns the number of clusters in the clusterer.\n *\n * @return {number} The number of clusters.\n */\n\n\nMarkerClusterer.prototype.getTotalClusters = function () {\n  return this.clusters_.length;\n};\n/**\n * Returns the google map that the clusterer is associated with.\n *\n * @return {google.maps.Map} The map.\n */\n\n\nMarkerClusterer.prototype.getMap = function () {\n  return this.map_;\n};\n/**\n * Sets the google map that the clusterer is associated with.\n *\n * @param {google.maps.Map} map The map.\n */\n\n\nMarkerClusterer.prototype.setMap = function (map) {\n  this.map_ = map;\n};\n/**\n * Returns the size of the grid.\n *\n * @return {number} The grid size.\n */\n\n\nMarkerClusterer.prototype.getGridSize = function () {\n  return this.gridSize_;\n};\n/**\n * Sets the size of the grid.\n *\n * @param {number} size The grid size.\n */\n\n\nMarkerClusterer.prototype.setGridSize = function (size) {\n  this.gridSize_ = size;\n};\n/**\n * Returns the min cluster size.\n *\n * @return {number} The grid size.\n */\n\n\nMarkerClusterer.prototype.getMinClusterSize = function () {\n  return this.minClusterSize_;\n};\n/**\n * Sets the min cluster size.\n *\n * @param {number} size The grid size.\n */\n\n\nMarkerClusterer.prototype.setMinClusterSize = function (size) {\n  this.minClusterSize_ = size;\n};\n/**\n * Extends a bounds object by the grid size.\n *\n * @param {google.maps.LatLngBounds} bounds The bounds to extend.\n * @return {google.maps.LatLngBounds} The extended bounds.\n */\n\n\nMarkerClusterer.prototype.getExtendedBounds = function (bounds) {\n  var projection = this.getProjection(); // Turn the bounds into latlng.\n\n  var tr = new google.maps.LatLng(bounds.getNorthEast().lat(), bounds.getNorthEast().lng());\n  var bl = new google.maps.LatLng(bounds.getSouthWest().lat(), bounds.getSouthWest().lng()); // Convert the points to pixels and the extend out by the grid size.\n\n  var trPix = projection.fromLatLngToDivPixel(tr);\n  trPix.x += this.gridSize_;\n  trPix.y -= this.gridSize_;\n  var blPix = projection.fromLatLngToDivPixel(bl);\n  blPix.x -= this.gridSize_;\n  blPix.y += this.gridSize_; // Convert the pixel points back to LatLng\n\n  var ne = projection.fromDivPixelToLatLng(trPix);\n  var sw = projection.fromDivPixelToLatLng(blPix); // Extend the bounds to contain the new bounds.\n\n  bounds.extend(ne);\n  bounds.extend(sw);\n  return bounds;\n};\n/**\n * Determins if a marker is contained in a bounds.\n *\n * @param {google.maps.Marker} marker The marker to check.\n * @param {google.maps.LatLngBounds} bounds The bounds to check against.\n * @return {boolean} True if the marker is in the bounds.\n * @private\n */\n\n\nMarkerClusterer.prototype.isMarkerInBounds_ = function (marker, bounds) {\n  return bounds.contains(marker.getPosition());\n};\n/**\n * Clears all clusters and markers from the clusterer.\n */\n\n\nMarkerClusterer.prototype.clearMarkers = function () {\n  this.resetViewport(true); // Set the markers a empty array.\n\n  this.markers_ = [];\n};\n/**\n * Clears all existing clusters and recreates them.\n * @param {boolean} opt_hide To also hide the marker.\n */\n\n\nMarkerClusterer.prototype.resetViewport = function (opt_hide) {\n  // Remove all the clusters\n  for (var i = 0, cluster; cluster = this.clusters_[i]; i++) {\n    cluster.remove();\n  } // Reset the markers to not be added and to be invisible.\n\n\n  for (var i = 0, marker; marker = this.markers_[i]; i++) {\n    marker.isAdded = false;\n\n    if (opt_hide) {\n      marker.setMap(null);\n    }\n  }\n\n  this.clusters_ = [];\n};\n/**\n *\n */\n\n\nMarkerClusterer.prototype.repaint = function () {\n  var oldClusters = this.clusters_.slice();\n  this.clusters_.length = 0;\n  this.resetViewport();\n  this.redraw(); // Remove the old clusters.\n  // Do it in a timeout so the other clusters have been drawn first.\n\n  window.setTimeout(function () {\n    for (var i = 0, cluster; cluster = oldClusters[i]; i++) {\n      cluster.remove();\n    }\n  }, 0);\n};\n/**\n * Redraws the clusters.\n */\n\n\nMarkerClusterer.prototype.redraw = function () {\n  this.createClusters_();\n};\n/**\n * Calculates the distance between two latlng locations in km.\n * @see http://www.movable-type.co.uk/scripts/latlong.html\n *\n * @param {google.maps.LatLng} p1 The first lat lng point.\n * @param {google.maps.LatLng} p2 The second lat lng point.\n * @return {number} The distance between the two points in km.\n * @private\n*/\n\n\nMarkerClusterer.prototype.distanceBetweenPoints_ = function (p1, p2) {\n  if (!p1 || !p2) {\n    return 0;\n  }\n\n  var R = 6371; // Radius of the Earth in km\n\n  var dLat = (p2.lat() - p1.lat()) * Math.PI / 180;\n  var dLon = (p2.lng() - p1.lng()) * Math.PI / 180;\n  var a = Math.sin(dLat / 2) * Math.sin(dLat / 2) + Math.cos(p1.lat() * Math.PI / 180) * Math.cos(p2.lat() * Math.PI / 180) * Math.sin(dLon / 2) * Math.sin(dLon / 2);\n  var c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));\n  var d = R * c;\n  return d;\n};\n/**\n * Add a marker to a cluster, or creates a new cluster.\n *\n * @param {google.maps.Marker} marker The marker to add.\n * @private\n */\n\n\nMarkerClusterer.prototype.addToClosestCluster_ = function (marker) {\n  var distance = 40000; // Some large number\n\n  var clusterToAddTo = null;\n  var pos = marker.getPosition();\n\n  for (var i = 0, cluster; cluster = this.clusters_[i]; i++) {\n    var center = cluster.getCenter();\n\n    if (center) {\n      var d = this.distanceBetweenPoints_(center, marker.getPosition());\n\n      if (d < distance) {\n        distance = d;\n        clusterToAddTo = cluster;\n      }\n    }\n  }\n\n  if (clusterToAddTo && clusterToAddTo.isMarkerInClusterBounds(marker)) {\n    clusterToAddTo.addMarker(marker);\n  } else {\n    var cluster = new Cluster(this);\n    cluster.addMarker(marker);\n    this.clusters_.push(cluster);\n  }\n};\n/**\n * Creates the clusters.\n *\n * @private\n */\n\n\nMarkerClusterer.prototype.createClusters_ = function () {\n  if (!this.ready_) {\n    return;\n  } // Get our current map view bounds.\n  // Create a new bounds object so we don't affect the map.\n\n\n  var mapBounds = new google.maps.LatLngBounds(this.map_.getBounds().getSouthWest(), this.map_.getBounds().getNorthEast());\n  var bounds = this.getExtendedBounds(mapBounds);\n\n  for (var i = 0, marker; marker = this.markers_[i]; i++) {\n    if (!marker.isAdded && this.isMarkerInBounds_(marker, bounds)) {\n      this.addToClosestCluster_(marker);\n    }\n  }\n};\n/**\n * A cluster that contains markers.\n *\n * @param {MarkerClusterer} markerClusterer The markerclusterer that this\n *     cluster is associated with.\n * @constructor\n * @ignore\n */\n\n\nfunction Cluster(markerClusterer) {\n  this.markerClusterer_ = markerClusterer;\n  this.map_ = markerClusterer.getMap();\n  this.gridSize_ = markerClusterer.getGridSize();\n  this.minClusterSize_ = markerClusterer.getMinClusterSize();\n  this.averageCenter_ = markerClusterer.isAverageCenter();\n  this.center_ = null;\n  this.markers_ = [];\n  this.bounds_ = null;\n  this.clusterIcon_ = new ClusterIcon(this, markerClusterer.getStyles(), markerClusterer.getGridSize());\n}\n/**\n * Determins if a marker is already added to the cluster.\n *\n * @param {google.maps.Marker} marker The marker to check.\n * @return {boolean} True if the marker is already added.\n */\n\n\nCluster.prototype.isMarkerAlreadyAdded = function (marker) {\n  if (this.markers_.indexOf) {\n    return this.markers_.indexOf(marker) != -1;\n  } else {\n    for (var i = 0, m; m = this.markers_[i]; i++) {\n      if (m == marker) {\n        return true;\n      }\n    }\n  }\n\n  return false;\n};\n/**\n * Add a marker the cluster.\n *\n * @param {google.maps.Marker} marker The marker to add.\n * @return {boolean} True if the marker was added.\n */\n\n\nCluster.prototype.addMarker = function (marker) {\n  if (this.isMarkerAlreadyAdded(marker)) {\n    return false;\n  }\n\n  if (!this.center_) {\n    this.center_ = marker.getPosition();\n    this.calculateBounds_();\n  } else {\n    if (this.averageCenter_) {\n      var l = this.markers_.length + 1;\n      var lat = (this.center_.lat() * (l - 1) + marker.getPosition().lat()) / l;\n      var lng = (this.center_.lng() * (l - 1) + marker.getPosition().lng()) / l;\n      this.center_ = new google.maps.LatLng(lat, lng);\n      this.calculateBounds_();\n    }\n  }\n\n  marker.isAdded = true;\n  this.markers_.push(marker);\n  var len = this.markers_.length;\n\n  if (len < this.minClusterSize_ && marker.getMap() != this.map_) {\n    // Min cluster size not reached so show the marker.\n    marker.setMap(this.map_);\n  }\n\n  if (len == this.minClusterSize_) {\n    // Hide the markers that were showing.\n    for (var i = 0; i < len; i++) {\n      this.markers_[i].setMap(null);\n    }\n  }\n\n  if (len >= this.minClusterSize_) {\n    marker.setMap(null);\n  }\n\n  this.updateIcon();\n  return true;\n};\n/**\n * Returns the marker clusterer that the cluster is associated with.\n *\n * @return {MarkerClusterer} The associated marker clusterer.\n */\n\n\nCluster.prototype.getMarkerClusterer = function () {\n  return this.markerClusterer_;\n};\n/**\n * Returns the bounds of the cluster.\n *\n * @return {google.maps.LatLngBounds} the cluster bounds.\n */\n\n\nCluster.prototype.getBounds = function () {\n  var bounds = new google.maps.LatLngBounds(this.center_, this.center_);\n  var markers = this.getMarkers();\n\n  for (var i = 0, marker; marker = markers[i]; i++) {\n    bounds.extend(marker.getPosition());\n  }\n\n  return bounds;\n};\n/**\n * Removes the cluster\n */\n\n\nCluster.prototype.remove = function () {\n  this.clusterIcon_.remove();\n  this.markers_.length = 0;\n  delete this.markers_;\n};\n/**\n * Returns the number of markers in the cluster.\n *\n * @return {number} The number of markers in the cluster.\n */\n\n\nCluster.prototype.getSize = function () {\n  return this.markers_.length;\n};\n/**\n * Returns a list of the markers in the cluster.\n *\n * @return {Array.<google.maps.Marker>} The markers in the cluster.\n */\n\n\nCluster.prototype.getMarkers = function () {\n  return this.markers_;\n};\n/**\n * Returns the center of the cluster.\n *\n * @return {google.maps.LatLng} The cluster center.\n */\n\n\nCluster.prototype.getCenter = function () {\n  return this.center_;\n};\n/**\n * Calculated the extended bounds of the cluster with the grid.\n *\n * @private\n */\n\n\nCluster.prototype.calculateBounds_ = function () {\n  var bounds = new google.maps.LatLngBounds(this.center_, this.center_);\n  this.bounds_ = this.markerClusterer_.getExtendedBounds(bounds);\n};\n/**\n * Determines if a marker lies in the clusters bounds.\n *\n * @param {google.maps.Marker} marker The marker to check.\n * @return {boolean} True if the marker lies in the bounds.\n */\n\n\nCluster.prototype.isMarkerInClusterBounds = function (marker) {\n  return this.bounds_.contains(marker.getPosition());\n};\n/**\n * Returns the map that the cluster is associated with.\n *\n * @return {google.maps.Map} The map.\n */\n\n\nCluster.prototype.getMap = function () {\n  return this.map_;\n};\n/**\n * Updates the cluster icon\n */\n\n\nCluster.prototype.updateIcon = function () {\n  var zoom = this.map_.getZoom();\n  var mz = this.markerClusterer_.getMaxZoom();\n\n  if (mz && zoom > mz) {\n    // The zoom is greater than our max zoom so show all the markers in cluster.\n    for (var i = 0, marker; marker = this.markers_[i]; i++) {\n      marker.setMap(this.map_);\n    }\n\n    return;\n  }\n\n  if (this.markers_.length < this.minClusterSize_) {\n    // Min cluster size not yet reached.\n    this.clusterIcon_.hide();\n    return;\n  }\n\n  var numStyles = this.markerClusterer_.getStyles().length;\n  var sums = this.markerClusterer_.getCalculator()(this.markers_, numStyles);\n  this.clusterIcon_.setCenter(this.center_);\n  this.clusterIcon_.setSums(sums);\n  this.clusterIcon_.show();\n};\n/**\n * A cluster icon\n *\n * @param {Cluster} cluster The cluster to be associated with.\n * @param {Object} styles An object that has style properties:\n *     'url': (string) The image url.\n *     'height': (number) The image height.\n *     'width': (number) The image width.\n *     'anchor': (Array) The anchor position of the label text.\n *     'textColor': (string) The text color.\n *     'textSize': (number) The text size.\n *     'backgroundPosition: (string) The background postition x, y.\n *     'backgroundSize': (string) The background size\n * @param {number=} opt_padding Optional padding to apply to the cluster icon.\n * @constructor\n * @extends google.maps.OverlayView\n * @ignore\n */\n\n\nfunction ClusterIcon(cluster, styles, opt_padding) {\n  cluster.getMarkerClusterer().extend(ClusterIcon, google.maps.OverlayView);\n  this.styles_ = styles;\n  this.padding_ = opt_padding || 0;\n  this.cluster_ = cluster;\n  this.center_ = null;\n  this.map_ = cluster.getMap();\n  this.div_ = null;\n  this.sums_ = null;\n  this.visible_ = false;\n  this.setMap(this.map_);\n}\n/**\n * Triggers the clusterclick event and zoom's if the option is set.\n */\n\n\nClusterIcon.prototype.triggerClusterClick = function () {\n  var markerClusterer = this.cluster_.getMarkerClusterer(); // Trigger the clusterclick event.\n\n  google.maps.event.trigger(markerClusterer.map_, 'clusterclick', this.cluster_);\n\n  if (markerClusterer.isZoomOnClick()) {\n    // Zoom into the cluster.\n    this.map_.fitBounds(this.cluster_.getBounds());\n  }\n};\n/**\n * Adding the cluster icon to the dom.\n * @ignore\n */\n\n\nClusterIcon.prototype.onAdd = function () {\n  this.div_ = document.createElement('DIV');\n\n  if (this.visible_) {\n    var pos = this.getPosFromLatLng_(this.center_);\n    this.div_.style.cssText = this.createCss(pos);\n    this.div_.innerHTML = this.sums_.text;\n  }\n\n  var panes = this.getPanes();\n  panes.overlayMouseTarget.appendChild(this.div_);\n  var that = this;\n  google.maps.event.addDomListener(this.div_, 'click', function () {\n    that.triggerClusterClick();\n  });\n};\n/**\n * Returns the position to place the div dending on the latlng.\n *\n * @param {google.maps.LatLng} latlng The position in latlng.\n * @return {google.maps.Point} The position in pixels.\n * @private\n */\n\n\nClusterIcon.prototype.getPosFromLatLng_ = function (latlng) {\n  var pos = this.getProjection().fromLatLngToDivPixel(latlng);\n  pos.x -= parseInt(this.width_ / 2, 10);\n  pos.y -= parseInt(this.height_ / 2, 10);\n  return pos;\n};\n/**\n * Draw the icon.\n * @ignore\n */\n\n\nClusterIcon.prototype.draw = function () {\n  if (this.visible_) {\n    var pos = this.getPosFromLatLng_(this.center_);\n    this.div_.style.top = pos.y + 'px';\n    this.div_.style.left = pos.x + 'px';\n    this.div_.style.zIndex = google.maps.Marker.MAX_ZINDEX + 1;\n  }\n};\n/**\n * Hide the icon.\n */\n\n\nClusterIcon.prototype.hide = function () {\n  if (this.div_) {\n    this.div_.style.display = 'none';\n  }\n\n  this.visible_ = false;\n};\n/**\n * Position and show the icon.\n */\n\n\nClusterIcon.prototype.show = function () {\n  if (this.div_) {\n    var pos = this.getPosFromLatLng_(this.center_);\n    this.div_.style.cssText = this.createCss(pos);\n    this.div_.style.display = '';\n  }\n\n  this.visible_ = true;\n};\n/**\n * Remove the icon from the map\n */\n\n\nClusterIcon.prototype.remove = function () {\n  this.setMap(null);\n};\n/**\n * Implementation of the onRemove interface.\n * @ignore\n */\n\n\nClusterIcon.prototype.onRemove = function () {\n  if (this.div_ && this.div_.parentNode) {\n    this.hide();\n    this.div_.parentNode.removeChild(this.div_);\n    this.div_ = null;\n  }\n};\n/**\n * Set the sums of the icon.\n *\n * @param {Object} sums The sums containing:\n *   'text': (string) The text to display in the icon.\n *   'index': (number) The style index of the icon.\n */\n\n\nClusterIcon.prototype.setSums = function (sums) {\n  this.sums_ = sums;\n  this.text_ = sums.text;\n  this.index_ = sums.index;\n\n  if (this.div_) {\n    this.div_.innerHTML = sums.text;\n  }\n\n  this.useStyle();\n};\n/**\n * Sets the icon to the the styles.\n */\n\n\nClusterIcon.prototype.useStyle = function () {\n  var index = Math.max(0, this.sums_.index - 1);\n  index = Math.min(this.styles_.length - 1, index);\n  var style = this.styles_[index];\n  this.url_ = style['url'];\n  this.height_ = style['height'];\n  this.width_ = style['width'];\n  this.textColor_ = style['textColor'];\n  this.anchor_ = style['anchor'];\n  this.textSize_ = style['textSize'];\n  this.backgroundPosition_ = style['backgroundPosition'];\n  this.backgroundSize_ = style['backgroundSize'];\n};\n/**\n * Sets the center of the icon.\n *\n * @param {google.maps.LatLng} center The latlng to set as the center.\n */\n\n\nClusterIcon.prototype.setCenter = function (center) {\n  this.center_ = center;\n};\n/**\n * Create the css text based on the position of the icon.\n *\n * @param {google.maps.Point} pos The position.\n * @return {string} The css style text.\n */\n\n\nClusterIcon.prototype.createCss = function (pos) {\n  var style = [];\n  style.push('background-image:url(' + this.url_ + ');');\n  var backgroundPosition = this.backgroundPosition_ ? this.backgroundPosition_ : '0 0';\n  style.push('background-position:' + backgroundPosition + ';');\n  var backgroundSize = this.backgroundSize_ ? this.backgroundSize_ : 'contain';\n  style.push('background-size:' + backgroundSize + ';');\n\n  if ((0,_babel_runtime_helpers_typeof__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(this.anchor_) === 'object') {\n    if (typeof this.anchor_[0] === 'number' && this.anchor_[0] > 0 && this.anchor_[0] < this.height_) {\n      style.push('height:' + (this.height_ - this.anchor_[0]) + 'px; padding-top:' + this.anchor_[0] + 'px;');\n    } else {\n      style.push('height:' + this.height_ + 'px; line-height:' + this.height_ + 'px;');\n    }\n\n    if (typeof this.anchor_[1] === 'number' && this.anchor_[1] > 0 && this.anchor_[1] < this.width_) {\n      style.push('width:' + (this.width_ - this.anchor_[1]) + 'px; padding-left:' + this.anchor_[1] + 'px;');\n    } else {\n      style.push('width:' + this.width_ + 'px; text-align:center;');\n    }\n  } else {\n    style.push('height:' + this.height_ + 'px; line-height:' + this.height_ + 'px; width:' + this.width_ + 'px; text-align:center;');\n  }\n\n  var txtColor = this.textColor_ ? this.textColor_ : 'black';\n  var txtSize = this.textSize_ ? this.textSize_ : 11;\n  style.push('cursor:pointer; top:' + pos.y + 'px; left:' + pos.x + 'px; color:' + txtColor + '; position:absolute; font-size:' + txtSize + 'px; font-family:Arial,sans-serif; font-weight:bold');\n  return style.join('');\n}; // Export Symbols for Closure\n// If you are not going to compile with closure then you can remove the\n// code below.\n\n\nvar window = window || {};\nwindow['MarkerClusterer'] = MarkerClusterer;\nMarkerClusterer.prototype['addMarker'] = MarkerClusterer.prototype.addMarker;\nMarkerClusterer.prototype['addMarkers'] = MarkerClusterer.prototype.addMarkers;\nMarkerClusterer.prototype['clearMarkers'] = MarkerClusterer.prototype.clearMarkers;\nMarkerClusterer.prototype['fitMapToMarkers'] = MarkerClusterer.prototype.fitMapToMarkers;\nMarkerClusterer.prototype['getCalculator'] = MarkerClusterer.prototype.getCalculator;\nMarkerClusterer.prototype['getGridSize'] = MarkerClusterer.prototype.getGridSize;\nMarkerClusterer.prototype['getExtendedBounds'] = MarkerClusterer.prototype.getExtendedBounds;\nMarkerClusterer.prototype['getMap'] = MarkerClusterer.prototype.getMap;\nMarkerClusterer.prototype['getMarkers'] = MarkerClusterer.prototype.getMarkers;\nMarkerClusterer.prototype['getMaxZoom'] = MarkerClusterer.prototype.getMaxZoom;\nMarkerClusterer.prototype['getStyles'] = MarkerClusterer.prototype.getStyles;\nMarkerClusterer.prototype['getTotalClusters'] = MarkerClusterer.prototype.getTotalClusters;\nMarkerClusterer.prototype['getTotalMarkers'] = MarkerClusterer.prototype.getTotalMarkers;\nMarkerClusterer.prototype['redraw'] = MarkerClusterer.prototype.redraw;\nMarkerClusterer.prototype['removeMarker'] = MarkerClusterer.prototype.removeMarker;\nMarkerClusterer.prototype['removeMarkers'] = MarkerClusterer.prototype.removeMarkers;\nMarkerClusterer.prototype['resetViewport'] = MarkerClusterer.prototype.resetViewport;\nMarkerClusterer.prototype['repaint'] = MarkerClusterer.prototype.repaint;\nMarkerClusterer.prototype['setCalculator'] = MarkerClusterer.prototype.setCalculator;\nMarkerClusterer.prototype['setGridSize'] = MarkerClusterer.prototype.setGridSize;\nMarkerClusterer.prototype['setMaxZoom'] = MarkerClusterer.prototype.setMaxZoom;\nMarkerClusterer.prototype['onAdd'] = MarkerClusterer.prototype.onAdd;\nMarkerClusterer.prototype['draw'] = MarkerClusterer.prototype.draw;\nCluster.prototype['getCenter'] = Cluster.prototype.getCenter;\nCluster.prototype['getSize'] = Cluster.prototype.getSize;\nCluster.prototype['getMarkers'] = Cluster.prototype.getMarkers;\nClusterIcon.prototype['onAdd'] = ClusterIcon.prototype.onAdd;\nClusterIcon.prototype['draw'] = ClusterIcon.prototype.draw;\nClusterIcon.prototype['onRemove'] = ClusterIcon.prototype.onRemove;\n\nObject.keys = Object.keys || function (o) {\n  var result = [];\n\n  for (var name in o) {\n    if (o.hasOwnProperty(name)) result.push(name);\n  }\n\n  return result;\n};\n\n/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MarkerClusterer);\n\n//# sourceURL=webpack://dokan-pro/./modules/geolocation/assets/src/js/markerclusterer.js?");

/***/ }),

/***/ "./node_modules/@babel/runtime/helpers/esm/typeof.js":
/*!***********************************************************!*\
  !*** ./node_modules/@babel/runtime/helpers/esm/typeof.js ***!
  \***********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": () => (/* binding */ _typeof)\n/* harmony export */ });\nfunction _typeof(obj) {\n  \"@babel/helpers - typeof\";\n\n  if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") {\n    _typeof = function _typeof(obj) {\n      return typeof obj;\n    };\n  } else {\n    _typeof = function _typeof(obj) {\n      return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj;\n    };\n  }\n\n  return _typeof(obj);\n}\n\n//# sourceURL=webpack://dokan-pro/./node_modules/@babel/runtime/helpers/esm/typeof.js?");

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module can't be inlined because the eval devtool is used.
/******/ 	var __webpack_exports__ = __webpack_require__("./modules/geolocation/assets/src/js/locations-map-google-maps.js");
/******/ 	
/******/ })()
;